@extends('layouts.app')

@section('title', 'Knowledge Base')

@section('content')
<div class="knowledge-base-page">
    <div class="container">
        <h1>Knowledge Base</h1>
        
        <div class="search-section">
            <form action="{{ route('knowledgebase') }}" method="GET" class="search-form">
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search articles..." class="search-input">
                <button type="submit" class="search-button">Search</button>
            </form>
        </div>

        @if(request('search'))
            <p>Search results for: "{{ request('search') }}"</p>
        @endif

        <div class="knowledge-base-list">
            @forelse($items as $item)
                <div class="knowledge-base-item" id="{{ $item->id }}">
                    <h2>{{ $item->title }}</h2>
                    @if($item->category)
                        <span class="category-badge">{{ $item->category }}</span>
                    @endif
                    <div class="knowledge-content">
                        {!! nl2br(e($item->content)) !!}
                    </div>
                </div>
            @empty
                <p>No knowledge base articles available.</p>
            @endforelse
        </div>
    </div>
</div>
@endsection

